package com.najva.sdk.core.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;

import com.najva.sdk.BuildConfig;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;


public class Logger {
    private static int MAX_INDEX = 1000;
    private static int MAX_TAG_LENGTH = 70;
    private static int MAX_MSG_LENGTH = 400;
    private static int MAX_LINE_LENGTH = 500;
    private static String loggerFilePath;
    private static String indexFilePath;
    public static boolean isDebug = true;

    public static void v(String TAG, String msg) {
        if (BuildConfig.DEBUG == isDebug) {
            Log.v(TAG, msg);

            writeToFile(TAG, msg, "V");
        }
    }

    public static void d(String TAG, String msg) {
        if (BuildConfig.DEBUG == isDebug) {
            Log.d(TAG, msg);
            if(!loggerFilePath.isEmpty()){
                writeToFile(TAG, msg, "D");
            }
        }
    }

    public static void i(String TAG, String msg) {
        if (BuildConfig.DEBUG == isDebug) {
            Log.i(TAG, msg);
            if(!loggerFilePath.isEmpty()) {
                writeToFile(TAG, msg, "I");
            }
        }
    }

    public static void e(String TAG, String msg) {
        if (BuildConfig.DEBUG == isDebug) {
            Log.e(TAG, msg);
            if(!loggerFilePath.isEmpty()) {
                writeToFile(TAG, msg, "E");
            }
        }
    }

    public static void w(String TAG, String msg) {
        if (BuildConfig.DEBUG == isDebug) {
            Log.w(TAG, msg);
            if(!loggerFilePath.isEmpty()) {
                writeToFile(TAG, msg, "W");
            }
        }
    }

    public static void appendFile(String TAG, String msg) {
        if (BuildConfig.DEBUG == isDebug) {
            if(!loggerFilePath.isEmpty()) {
                writeToFile(TAG, msg, "F");
            }
        }
    }

    private static void setLoggerIndex(String filePath, int index) {
        index = resetIndex(index);
        FileManager.writeToFile(filePath,"" + index);
    }

    private static int resetIndex(int index) {
        if (index == MAX_INDEX) {
            index = 0;
        }
        return index;
    }

    private static int getLoggerIndex(String filePath) {
        if (FileManager.readFromFile(filePath) == null){
            return 0;
        }else {
            return  Integer.parseInt(FileManager.readFromFile(filePath));
        }
    }

    private static void writeToFile(String TAG, String msg, String type) {
        if (TAG.length() > MAX_TAG_LENGTH) {
            TAG = TAG.substring(0, MAX_TAG_LENGTH);
        }
        if (msg.length() > MAX_MSG_LENGTH) {
            msg = msg.substring(0, MAX_MSG_LENGTH - 1);
        }
        Date currentDate = new Date(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String content = "\n" + dateFormat.format(currentDate) + " - " + type + "/" + TAG + ": " + msg;
        if (TAG.length() < MAX_TAG_LENGTH || msg.length() < MAX_MSG_LENGTH) {
            content = fillWithSpace(TAG, msg, content);
        }
        int currentIndex = getLoggerIndex(indexFilePath);
        FileManager.appendToRandomAccessFile(getLoggerFilePath(), content, currentIndex, MAX_LINE_LENGTH);
        setLoggerIndex(indexFilePath, currentIndex + 1);
    }

    private static String fillWithSpace(String TAG, String msg, String content) {
        int constantsLength = 30;
        int lineLength = TAG.length() + msg.length() + constantsLength;
        char[] spaceChars = new char[MAX_LINE_LENGTH - lineLength - 1];
        char space = ' ';
        Arrays.fill(spaceChars, space);
        content = content.concat(new String(spaceChars));
        return content;
    }

    public static String getLoggerFilePath() {
        return loggerFilePath;
    }

    public static void setLoggerFilePath(String filePath){
        loggerFilePath = filePath;
    }

    public static String getIndexFilePath() {
        return indexFilePath;
    }

    public static void setIndexFilePath(String indexFilePath) {
        Logger.indexFilePath = indexFilePath;
    }
}
