package com.najva.sdk.app;


import android.content.Context;

import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;

import com.android.volley.Request;
import com.najva.sdk.core.utils.ApiInfo;
import com.najva.sdk.core.utils.FileManager;
import com.najva.sdk.core.utils.Logger;
import com.najva.sdk.core.utils.Parameter;
import com.najva.sdk.core.Utility;
import com.najva.sdk.core.utils.StaticFields;
import com.najva.sdk.core.works.FormRequestWorker;

/**
 * POST new version of application to server
 */

public class AppVersionControllerImpl extends Thread implements AppVersionController {
    private final Context context;
    private final String TAG = "AppVersionController";

    public AppVersionControllerImpl(Context context) {
        this.context = context;
    }

    @Override
    public void load() {
        // check app-version every day
        checkAppVersion();
    }

    @Override
    public void loadAsync() {
        start();
    }

    @Override
    public void run() {
        load();
    }

    private void checkAppVersion() {
        Logger.i(TAG, "checkAppVersion: initialized");
        String lastVersion = getLastAppVersionSaved();
        final String currentVersion = Utility.getAppVersion(context);
        saveLastAppVersion();
        if (lastVersion == null || !lastVersion.equalsIgnoreCase(currentVersion)) {

            final OneTimeWorkRequest worker = new FormRequestWorker.Builder(context)
                    .setUrl(ApiInfo.UPDATE_OPERATOR.getValue())
                    .setMethod(Request.Method.POST)
                    .addParam(StaticFields.APP_VERSION, currentVersion)
                    .build();
            WorkManager.getInstance(context).enqueue(worker);

        }
    }

    private String getLastAppVersionSaved() {
        return FileManager.readFromFile(this.context, Parameter.APP_VERSION_FILE_NAME.getValue());
    }

    private void saveLastAppVersion() {
        FileManager.writeToFile(this.context, Parameter.APP_VERSION_FILE_NAME.getValue(), Utility.getAppVersion(context));
    }
}