package com.najva.sdk.core.works;

import android.content.Context;
import androidx.annotation.NonNull;

import androidx.work.Worker;
import androidx.work.WorkerParameters;

import com.najva.sdk.core.utils.WorkManager;


abstract class BaseWorker extends Worker {
    private int retries = 0;
    BaseWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
    }

    Result retry(){
        if (retries < WorkManager.MAX_RETRY){
            retries ++;
            return Result.retry();
        }
        return Result.failure();
    }
}
