package com.najva.sdk.core.utils;

import androidx.annotation.Nullable;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.Response;
import com.android.volley.toolbox.RequestFuture;
import com.android.volley.toolbox.StringRequest;
import com.najva.sdk.BuildConfig;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class MetaRequest extends StringRequest {
    private static final String TAG = "MetaRequest";
    private static final String SET_COOKIE = "Set-Cookie";
    private CookieManager cookieManager;
    private Map<String, String> params = new HashMap<>();
    private Map<String, String> headers = new HashMap<>();
    private RequestFuture<String> future;

    private String uuid = UUID.randomUUID().toString();

    MetaRequest(int method, String url, Response.Listener<String> listener, @Nullable Response.ErrorListener errorListener) {
        super(method, url, listener, errorListener);
        LogDetails(url);
    }

    private void LogDetails(String url) {
        Logger.d(TAG, "url: " + url);
    }


    void setCookieManager(CookieManager manager) {
        this.cookieManager = manager;
    }

    private CookieManager getCookieManager() {
        return cookieManager;
    }

    @Override
    protected Response<String> parseNetworkResponse(NetworkResponse response) {

        handleNetworkResponse(response);

        return super.parseNetworkResponse(response);
    }

    private void handleNetworkResponse(NetworkResponse response) {
        Map<String, String> headers = response.headers;
        try {
            String cookies = headers.get(SET_COOKIE);
            updateCookies(cookies);
        } catch (Exception ignored) {
        }

        for (com.android.volley.Header h : response.allHeaders) {
            if (h.getName().equalsIgnoreCase(SET_COOKIE)) {
                getCookieManager().saveCookie(h.getValue());
            }
        }

    }

    @Override
    public Map<String, String> getHeaders() throws AuthFailureError {

        if (cookieManager == null) return super.getHeaders();

        headers.put(StaticFields.COOKIE, cookieManager.getCookies());
        headers.put(StaticFields.NAJVA_SDK_VERSION, BuildConfig.VERSION_NAME);
        return headers;
    }


    @Override
    public Map<String, String> getParams() {
        return params;
    }

    void addHeader(String key, String value) {
        headers.put(key, value);
    }

    void addPostParams(String key, String value) {
        params.put(key, value);
    }

    private void updateCookies(String cookies) {
        if (cookieManager != null)
            cookieManager.saveCookie(cookies);
    }

    void setFuture(RequestFuture<String> future) {
        this.future = future;
    }

    public RequestFuture<String> getFuture() {
        return future;
    }
}
