package com.najva.sdk.runnables;

import android.content.Context;
import android.content.Intent;

import com.najva.sdk.Najva;
import com.najva.sdk.NajvaClient;
import com.najva.sdk.NajvaClientReceiver;
import com.najva.sdk.NotificationReceiveListener;
import com.najva.sdk.NajvaRunnable;
import com.najva.sdk.core.utils.StaticFields;

public class NotificationReceiverHandler implements NajvaRunnable {

    public static void sendBroadcast(Context context, Intent intent){
        Intent sendIntent = new Intent(NajvaClientReceiver.ACTION);
        sendIntent.putExtra(StaticFields.ACTION,StaticFields.EVENT_NOTIFICATION_RECEIVER);
        sendIntent.putExtras(intent);
        context.sendBroadcast(sendIntent);
    }

    @Override
    public void run(Intent data) {
        if(NajvaClient.configuration.getReceiveNotificationListener() != null){
            NajvaClient.configuration.getReceiveNotificationListener()
                    .onReceiveNotification(data.getStringExtra(Najva.MESSAGE_ID));
        }
    }
}
