package com.najva.sdk.core.utils;

import android.content.Context;
import androidx.annotation.NonNull;

import org.json.JSONArray;
import org.json.JSONException;


public class JsonFile {
    private static JsonFile instance;
    private static JSONArray array;

    public static JsonFile getInstance() {
        if (instance == null)
            instance = new JsonFile();
        return instance;
    }

    private JsonFile() {
        array = new JSONArray();
    }

    public void writeAsJson(@NonNull Context context, @NonNull String data) {
        array.put(data);
        FileManager.writeToCache(context, Parameter.NAJVA_CACHE_FILE_NAME.getValue(), array.toString());
    }

    public JSONArray readFromJsonFile(@NonNull Context context) {
        JSONArray jsonArray = null;
        try {
            jsonArray = new JSONArray(FileManager.readFromCache(context, Parameter.NAJVA_CACHE_FILE_NAME.getValue()));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonArray;
    }
}
