package com.najva.sdk.runnables;

import android.content.Context;
import android.content.Intent;

import com.najva.sdk.NajvaClientReceiver;
import com.najva.sdk.NajvaRunnable;
import com.najva.sdk.UserSubscriptionListener;
import com.najva.sdk.core.utils.StaticFields;

public class NajvaSubscriberTokenHandler implements NajvaRunnable {

    public static void sendBroadcast(Context context, Intent intent){
        Intent sendIntent = new Intent(context, NajvaClientReceiver.class);
        sendIntent.setAction(NajvaClientReceiver.ACTION);
        sendIntent.putExtra(StaticFields.ACTION,StaticFields.EVENT_TYPE_TOKEN);
        sendIntent.putExtras(intent);
        context.sendBroadcast(sendIntent);
    }

    private UserSubscriptionListener listener;

    public NajvaSubscriberTokenHandler(UserSubscriptionListener listener){

        this.listener = listener;
    }
    @Override
    public void run(Intent data) {
        String token = data.getStringExtra(StaticFields.NAJVA_TOKEN);
        listener.onUserSubscribed(token);
    }
}
