package com.najva.sdk.runnables;

import android.content.Context;
import android.content.Intent;

import com.najva.sdk.NajvaClientReceiver;
import com.najva.sdk.NajvaJsonDataListener;
import com.najva.sdk.NajvaRunnable;
import com.najva.sdk.core.utils.JsonFile;
import com.najva.sdk.core.utils.StaticFields;

public class NajvaJsonHandler implements NajvaRunnable {

    public static void sendBroadcast(Context context,Intent intent){
        Intent sendIntent = new Intent(context, NajvaClientReceiver.class);
        sendIntent.setAction(NajvaClientReceiver.ACTION);
        sendIntent.putExtra(StaticFields.ACTION,StaticFields.EVENT_TYPE_JSON);
        sendIntent.putExtras(intent);
        context.sendBroadcast(sendIntent);
    }

    private Context context;
    private NajvaJsonDataListener listener;

    public NajvaJsonHandler(Context context, NajvaJsonDataListener listener) {
        this.context = context;

        this.listener = listener;
    }

    @Override
    public void run(Intent data) {
        String json = data.getStringExtra(StaticFields.JSON_DATA);
        if (listener != null)
            listener.onReceiveJson(json);
        else
            JsonFile.getInstance().writeAsJson(context, json);
    }
}
