package com.najva.sdk.remote_config;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import android.util.Log;

import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkInfo;
import androidx.work.WorkManager;

import com.najva.sdk.BuildConfig;
import com.najva.sdk.core.Utility;
import com.najva.sdk.core.utils.FileManager;
import com.najva.sdk.core.utils.Parameter;
import com.najva.sdk.core.utils.StaticFields;
import com.najva.sdk.core.works.FormRequestWorker;


import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

import static com.najva.sdk.core.utils.StaticFields.NAME;

/**
 * Work in progress
 */
public class RemoteConfigControllerImpl extends Thread implements RemoteConfigController {
    private Context context;
    private static final String DATE_PATTERN = "dd/MM/yyyy";
    public static final String TAG = "RemoteConfig";
    private static final long DURATION = 14;
    private SimpleDateFormat format;

    public RemoteConfigControllerImpl(Context context) {
        this.context = context;
        format = new SimpleDateFormat(DATE_PATTERN, Locale.US);
    }

    @Override
    public void load() {
        getConfigFromServer();
    }

    @Override
    public void loadAsync() {
        start();
    }

    @Override
    public void run() {
        load();
    }

    private void getConfigFromServer() {
        if (!Utility.isSubscribed(context)) return;
        if (checkLastLoginTime()) {
            OneTimeWorkRequest remoteRequest = new FormRequestWorker.Builder(context)
                    .setUrl(getRemoteRequestUrl())
                    .build();
            WorkManager.getInstance().enqueue(remoteRequest);

            final LiveData<WorkInfo> data = WorkManager.getInstance().getWorkInfoByIdLiveData(remoteRequest.getId());
            data.observeForever(new Observer<WorkInfo>() {
                @Override
                public void onChanged(@Nullable WorkInfo workInfo) {
                    if (workInfo == null) return;
                    if (workInfo.getState().equals(WorkInfo.State.SUCCEEDED)) {
                        saveRemoteConfig(workInfo.getOutputData().getString(StaticFields.RESPONSE));
                        data.removeObserver(this);
                    }
                }
            });
        }

    }

    public void saveRemoteConfig(String response) {
        FileManager.writeToFile(context,Parameter.LAST_CONFIG_TIME.getValue(),format.format(new Date(System.currentTimeMillis())));
        Log.d(TAG, "saveRemoteConfig: " + response);
        try {
            JSONObject object = new JSONObject(response);
            Log.d(TAG, "saveRemoteConfig: " + object);
            JSONObject remoteConfigData = object.getJSONObject(StaticFields.REMOTE_CONFIG);
            Log.d(TAG, "saveRemoteConfig: " + remoteConfigData);
            SharedPreferences preferences = context.getSharedPreferences(NAME, Context.MODE_PRIVATE);
            SharedPreferences.Editor editor = preferences.edit();
            Iterator<String> keys = remoteConfigData.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                editor.putString(key, remoteConfigData.getString(key));
            }
            editor.apply();
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private String getRemoteRequestUrl() {
        return BuildConfig.HOST;//test
    }

    /**
     * @return <>true</> if last login time of user is before two week ago
     * else <>false</> return
     */
    private boolean checkLastLoginTime() {
        String loginTimeToString = FileManager.readFromFile(this.context, Parameter.LAST_UPDATE_LOGIN_TIME.getValue());

        if (loginTimeToString == null || loginTimeToString.isEmpty() ) {
            FileManager.writeToFile(context, Parameter.LAST_CONFIG_TIME.getValue(), format.format(new Date(System.currentTimeMillis())));
            Log.d(TAG, "checkLastLoginTime: loginTimeToString isEmpty");
            return true;
        }
        try {
            Date lastLoginTime = format.parse(loginTimeToString);
            Date twoWeekAgo = new Date(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(DURATION));
            if (lastLoginTime.before(twoWeekAgo) && lastLoginTime.getMonth() == new Date(System.currentTimeMillis()).getMonth() && lastLoginTime.getYear() == new Date(System.currentTimeMillis()).getYear())
                return true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;

    }
}
