package com.najva.sdk.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;

import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;

import com.android.volley.Request;
import com.najva.sdk.core.utils.ApiInfo;
import com.najva.sdk.core.utils.StaticFields;
import com.najva.sdk.core.works.FormRequestWorker;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;

public class InstallPackageReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        String packageName = intent.getData().getEncodedSchemeSpecificPart();
        PackageManager packageManager = context.getPackageManager();
        String appLabel;
        try {
            appLabel = (String) packageManager.getApplicationLabel(packageManager.getApplicationInfo(packageName, PackageManager.GET_META_DATA));
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return;
        }

        addPackageInfoRequest(context, packageName, appLabel);
    }

    private void addPackageInfoRequest(final Context context, final String packageName, final String appLabel) {
        OneTimeWorkRequest oneTimeWorkRequest = new FormRequestWorker.Builder(context)
                .setMethod(Request.Method.POST)
                .setUrl(ApiInfo.CHANGE_DEVICE_INFO.getValue())
                .setParams(getPackageInfoParams(packageName, appLabel))
                .build();
        WorkManager.getInstance().enqueue(oneTimeWorkRequest);
    }

    private HashMap<String, String> getPackageInfoParams(String packageName, String appLabel) {
        HashMap<String, String> params = new HashMap<>();

        String encodedAppLabel = appLabel;
        try {
            encodedAppLabel = URLEncoder.encode(encodedAppLabel, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        params.put(StaticFields.OPERATION, StaticFields.OPERATION_ADD);
        params.put(StaticFields.PACKAGE_NAME, packageName);
        params.put(StaticFields.APP_LABEL, encodedAppLabel);

        return params;
    }

}
