package com.najva.sdk.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;

import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;

import com.android.volley.Request;
import com.najva.sdk.core.utils.ApiInfo;
import com.najva.sdk.core.utils.FileManager;
import com.najva.sdk.core.utils.Parameter;
import com.najva.sdk.core.utils.StaticFields;
import com.najva.sdk.core.works.FormRequestWorker;

import java.util.HashMap;

/**
 * created by sina
 * listens to simcard changes and sends network operator to the najva server
 */
public class ChangeSimCardReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        String newOperator = getSimOperatorName(context);
        if (!newOperator.equalsIgnoreCase(getLastSimCardOperator(context))) {
            saveNewOperator(context);
            sendNewOperatorToServer(context);
        }
    }

    private String getSimOperatorName(Context context) {
        TelephonyManager manager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        assert manager != null;
        return manager.getSimOperatorName();
    }

    private String getLastSimCardOperator(Context context) {
       String lastOperator =  FileManager.readFromFile(context,Parameter.OPERATOR_NAME_FILE_NAME.getValue());
       if (lastOperator == null || lastOperator.isEmpty())
           return "";
       return lastOperator;
    }

    private void saveNewOperator(Context context) {
        FileManager.writeToFile(context,Parameter.OPERATOR_NAME_FILE_NAME.getValue(),getSimOperatorName(context));
    }

    private void sendNewOperatorToServer(final Context context) {
        OneTimeWorkRequest oneTimeWorkRequest = new FormRequestWorker.Builder(context)
                .setUrl(ApiInfo.UPDATE_OPERATOR.getValue())
                .setMethod(Request.Method.POST)
                .setParams(getOperatorParams(getSimOperatorName(context)))
                .build();
        WorkManager.getInstance().enqueue(oneTimeWorkRequest);

    }

    private HashMap<String, String> getOperatorParams(String operator) {
        HashMap<String, String> params = new HashMap<>();
        params.put(StaticFields.SIM_CARD_OPERATOR, operator);

        return params;
    }
}
