package com.najva.sdk.push_notification;

import android.content.Context;
import android.util.Log;

import androidx.annotation.NonNull;

import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.iid.FirebaseInstanceId;
import com.najva.sdk.ClientMetaData;
import com.najva.sdk.Najva;
import com.najva.sdk.campaign.CampaignController;
import com.najva.sdk.campaign.CampaignControllerImpl;
import com.najva.sdk.core.utils.Parameter;
import com.najva.sdk.core.utils.StaticFields;
import com.najva.sdk.location.LocationControllerImpl;
import com.najva.sdk.remote_config.RemoteConfigControllerImpl;

/**
 * created for initialize FirebaseApp
 */

public class PushNotificationControllerImpl extends Thread implements PushNotificationController {

    private static final String TAG = "PushNotification";

    private final Context context;
    private final String apiKey;
    private final int websiteId;
    private String najvaToken;

    public PushNotificationControllerImpl(@NonNull Context context, @NonNull String apiKey,
                                          int websiteId, String najvaToken) {
        this.context = context;
        this.apiKey = apiKey;
        this.websiteId = websiteId;
        this.najvaToken = najvaToken;
    }

    @Override
    public void load() {

        Log.d(TAG, "load: initialized");

        FirebaseOptions options = new FirebaseOptions.Builder()
                .setApplicationId(Parameter.FIREBASE_APPLICATION_ID.getValue()) // Required for Analytics.
                .setApiKey(Parameter.FIREBASE_API_KEY.getValue()) // Required for Auth.
                .setDatabaseUrl(Parameter.FIREBASE_DATABASE_URL.getValue()) // Required for RTDB.
                .build();
        try {
            //FirebaseApp.getInstance();
//            FirebaseApp.initializeApp(context);
            FirebaseApp.getInstance();
        } catch (Exception e) {
            e.printStackTrace();
            FirebaseApp.initializeApp(context, options);
            StaticFields.NAJVA_IS_DEFAULT = true;
        }

        registerIfNeeded(context);

    }

    private void registerIfNeeded(Context context) {
        //checking if firebase token is available
        String firebaseToken = FirebaseInstanceId.getInstance(getFireBaseInstance()).getToken();
        String lastFirebaseToken = FirebaseInstanceId.getInstance(getFireBaseInstance()).getToken();
        if (!isRegistrationNeeded(firebaseToken, najvaToken, lastFirebaseToken)) return;

        // firebase token is available and najva token is not so we must register device

        ClientMetaData.setApiKey(context, this.apiKey);
        ClientMetaData.setToken(firebaseToken);
        ClientMetaData.setWebsiteId(websiteId);
        CampaignController campaignController = new CampaignControllerImpl(context,
                new LocationControllerImpl(context),
                new RemoteConfigControllerImpl(context),
                ClientMetaData.getParams());
        campaignController.loadAsync();
    }

    private boolean isRegistrationNeeded(String firebaseToken, String najvaToken, String lastFirebaseToken) {
        if (firebaseToken == null) return false;
        if (!firebaseToken.equals(lastFirebaseToken)) return true;
        return najvaToken == null && !firebaseToken.isEmpty();
    }


    private FirebaseApp getFireBaseInstance() {
        try {
            return FirebaseApp.getInstance();
        } catch (Exception ignored) {
            return FirebaseApp.getInstance(this.apiKey);
        }
    }

    @Override
    public void loadAsync() {
        start();
    }

    @Override
    public void run() {
        load();
    }
}
