package com.najva.sdk.global;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.Nullable;

import com.najva.sdk.R;
import com.najva.sdk.core.utils.StaticFields;

public class TokenActivity extends Activity {

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_token);

        final String token = getSharedPreferences(StaticFields.PUBLIC_PREFS,MODE_PRIVATE)
                .getString(StaticFields.NAJVA_TOKEN,getString(R.string.token_not_availale));

        TextView textView = findViewById(R.id.text_token);
        textView.setText(token);

        findViewById(R.id.copy).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                ClipboardManager clipboard = (ClipboardManager) getSystemService(Context.CLIPBOARD_SERVICE);
                ClipData clip = ClipData.newPlainText("najva-token", token);
                clipboard.setPrimaryClip(clip);
                Toast.makeText(TokenActivity.this,"Token copied to clipboard", Toast.LENGTH_LONG).show();
            }
        });

    }
}
