package com.najva.sdk.event_management.view_observer;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;

import com.najva.sdk.event_management.TagManager;
import com.najva.sdk.event_management.database.SelectAllRulesTask;
import com.najva.sdk.event_management.model.ActivityRule;
import com.najva.sdk.event_management.model.Rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventManager implements Application.ActivityLifecycleCallbacks,
        SelectAllRulesTask.OnRulesLoadListener {

    private boolean rulesLoaded = false;

    private final TagManager tagManager;
    private final ViewManager viewManager;

    private List<Rule> rules;

    private Map<String, ActivityRule> activityRules = new HashMap<>();

    private Map<String,Boolean> activityHandleStatus = new HashMap<>();

    private Activity unHandledActivity = null;

    public static Class RIdClass;

    public EventManager(Context application, TagManager tagManager) {
        this.tagManager = tagManager;
        tagManager.getRules(this);
        viewManager = new ViewManager(tagManager);

        findRClass(application.getPackageName());

    }

    private void findRClass(String packageName) {
        String className = packageName + ".R";
        try {
            Class rClass = Class.forName(className);
            Class[] classes = rClass.getDeclaredClasses();
            for (Class c : classes) {
                if (c.getSimpleName().equals("id")) {
                    RIdClass = c;
                    return;
                }
            }
        } catch (ClassNotFoundException e) {
            Log.d("EventManager", "cannot find R class");
        }
    }

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        Log.d("EventManager","activity created.");

        // TODO read parameter from saved instance and update activity handle status.

        viewManager.registerFragmentCallback(activity);
    }

    @Override
    public void onActivityStarted(Activity activity) {


    }

    private void initItemsClickListener(Activity activity) {


        String activityName = getActivityShortName(activity);
        Log.d("EventManager", "handling " + activityName);

        ActivityRule activityRule = activityRules.get(activityName);

        boolean isActivityHandled = getActivityStatus(activityName);

        if (rules != null && !isActivityHandled) {
            Log.d("EventManager", "activity rules size: " + rules.size());

            setClickListenerForActivity(activity, activityRule);
            activityHandleStatus.put(activityName,true);
        }

    }

    private boolean getActivityStatus(String activityName) {
        Boolean handleStatus = activityHandleStatus.get(activityName);
        if (handleStatus == null) return false;

        return handleStatus;
    }

    private String getActivityShortName(Activity activity) {
        return activity.getComponentName().getShortClassName().replace(".", "");
    }

    private void setClickListenerForActivity(Activity activity, ActivityRule activityRule) {
        if (activityRule == null) return;

        viewManager.handleActivity(activityRule, activity);
    }

    @Override
    public void onActivityResumed(Activity activity) {
        Log.d("EventManager", activity.getComponentName().getClassName());


        if (rulesLoaded)
            initItemsClickListener(activity);
        else
            unHandledActivity = activity;
    }

    @Override
    public void onActivityPaused(Activity activity) {
        unHandledActivity = null;
    }

    @Override
    public void onActivityStopped(Activity activity) {
    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(Activity activity) {
        viewManager.onActivityDestroyed(activity);
    }

    @Override
    public void onRulesLoaded(List<Rule> rules) {
        rulesLoaded = true;
        this.rules = rules;
        parseRules();
        if (unHandledActivity != null) {
            initItemsClickListener(unHandledActivity);
        }
    }

    private void parseRules() {
        Map<String, List<Rule>> ar = new HashMap<>();
        for (Rule rule : this.rules) {
            Log.d("EventManager",rule.toString());
            List<Rule> rules = ar.get(rule.getActivityName());
            if (rules != null) {
                rules.add(rule);
            } else {
                rules = new ArrayList<>();
                rules.add(rule);
                ar.put(rule.getActivityName(), rules);
            }
        }

        for (String key : ar.keySet()) {
            List<Rule> rules = ar.get(key);
            if (rules!=null) {
                ActivityRule rule = new ActivityRule();
                rule.setName(key);
                rule.setRules(rules);
                this.activityRules.put(key, rule);
            }
        }
    }
}
