package com.najva.sdk.event_management.model;

import android.util.Log;

import androidx.annotation.NonNull;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class Tag {

    public static Tag parseJson(JSONObject json){
        try {
            Tag tag = new Tag(json.getInt("id"));
            tag.setName(json.getString("name"));
            tag.setOperator(json.getString("operator"));
            JSONArray array = json.getJSONArray("rules");
            for (int i=0;i<array.length();i++){
                JSONObject object = new JSONObject();
                Rule rule = Rule.parseJson(object);
                if (rule!=null){
                    tag.addRule(rule);
                }
            }
            return tag;
        } catch (JSONException e) {
            Log.d("TagParser","cannot parse input json");
        }
        return null;
    }

    public static final String OPERATOR_ADD = "add";
    public static final String OPERATOR_OR  = "or" ;
    public static final String OPERATOR_SEQ = "sequence";

    private int id;
    private String name;
    private String operator;

    private List<Rule> rules = new ArrayList<>();

    public Tag(int id){
        this.id = id;
    }

    public int getId() {
        return id;
    }

    public List<Rule> getRules() {
        return rules;
    }

    public String getName() {
        return name;
    }

    public String getOperator() {
        return operator;
    }

    public Rule getRuleAt(int index) {
        return rules.get(index);
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setRules(@NonNull List<Rule> rules) {
        this.rules = rules;
    }

    public void addRule(Rule rule) {
        rules.add(rule);
    }

}
