package com.najva.sdk.event_management.model;

import android.util.Log;

import androidx.annotation.NonNull;

import org.json.JSONException;
import org.json.JSONObject;

public class Rule {

    public static Rule parseJson(JSONObject json) {
        try {
            Rule rule = new Rule(json.getInt("id"));
            rule.setType(json.getString("type"));
            rule.setAction(json.getString("action"));
            rule.setActivityName(json.getString("activity_name"));
            rule.setItemId(json.getString("item_id"));
            return rule;
        } catch (JSONException e) {
            Log.e("RuleParser", "cannot parse input json");
        }
        return null;
    }

    // rule types that specifies that rule must be applied to activity or dialog
    public static final String RULE_TYPE_ACTIVITY = "activity";
    public static final String RULE_TYPE_DIALOG = "dialog";

    // rule action types that specifies item must be clicked or checked or on editor action clicked.
    public static final String ACTION_TYPE_CLICK = "click";
    public static final String ACTION_TYPE_CHECK = "check";
    public static final String ACTION_TYPE_EDIT = "edit";

    private int id;
    private String type;
    private String itemId;
    private String listId;
    private String fragmentName;
    private String action;
    private String activityName;
    private int satisfied = 0;

    public Rule(int id) {
        this.id = id;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getId() {
        return id;
    }

    public String getAction() {
        return action;
    }

    public String getActivityName() {
        return activityName;
    }

    public String getItemId() {
        return itemId;
    }

    public String getType() {
        return type;
    }

    public boolean isSatisfied() {
        return satisfied == 1;
    }

    public int getSatisfied() {
        return satisfied;
    }

    public void setSatisfied(boolean satisfied) {
        this.satisfied = satisfied ? 1 : 0;
    }

    public String getFragmentName() {
        return fragmentName;
    }

    public String getListId() {
        return listId;
    }

    public void setFragmentName(String fragmentName) {
        this.fragmentName = fragmentName;
    }

    public void setListId(String listId) {
        this.listId = listId;
    }

    public boolean hasFragment() {
        return fragmentName != null && !fragmentName.isEmpty();
    }

    public boolean hasList() {
        return listId != null && !listId.isEmpty();
    }

    @NonNull
    @Override
    public String toString() {
        return "activityName: " + activityName + "\tfragment: " + fragmentName + "\tlistId: " + listId + "\titemId: " + itemId;
    }
}
