package com.najva.sdk.event_management.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FragmentRule {
    String name;
    private List<Rule> rules = new ArrayList<>();

    private List<ListRule> listRules = new ArrayList<>();

    public void setRules(List<Rule> rules) {
        Map<String, List<Rule>> listRules = new HashMap<>();

        for (Rule rule : rules) {
            if (rule.hasList()) {
                List<Rule> lr = listRules.get(rule.getListId());
                if (lr != null) {
                    lr.add(rule);
                } else {
                    lr = new ArrayList<>();
                    lr.add(rule);
                    listRules.put(rule.getListId(), lr);
                }
            } else {
                this.rules.add(rule);
            }
        }

        for (String key : listRules.keySet()) {
            List<Rule> lr = listRules.get(key);
            ListRule listRule = new ListRule();
            listRule.name = key;
            listRule.setRuels(lr);
            this.listRules.add(listRule);
        }
    }

    public String getName() {
        return name;
    }

    public List<Rule> getRules() {
        return rules;
    }

    public List<ListRule> getListRules() {
        return listRules;
    }
}
