package com.najva.sdk.event_management.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActivityRule {
    private String name;
    private List<Rule> rules = new ArrayList<>();

    private List<FragmentRule> fragmentRules = new ArrayList<>();
    private List<ListRule> listRules = new ArrayList<>();

    public void setRules(List<Rule> rules){
        Map<String,List<Rule>> fragmentRules = new HashMap<>();
        Map<String,List<Rule>> listRules = new HashMap<>();

        for (Rule rule : rules){
            if (rule.hasFragment()){
                List<Rule> fr = fragmentRules.get(rule.getFragmentName());
                if (fr!=null){
                    fr.add(rule);
                } else {
                    fr = new ArrayList<>();
                    fr.add(rule);
                    fragmentRules.put(rule.getFragmentName(),fr);
                }
            } else if (rule.hasList()){
                List<Rule> lr = listRules.get(rule.getListId());
                if (lr!=null){
                    lr.add(rule);
                } else {
                    lr = new ArrayList<>();
                    lr.add(rule);
                    listRules.put(rule.getListId(),lr);
                }
            } else {
                this.rules.add(rule);
            }
        }

        for (String key: fragmentRules.keySet()){
            List<Rule> fr = fragmentRules.get(key);
            FragmentRule fragmentRule = new FragmentRule();
            fragmentRule.name = key;
            fragmentRule.setRules(fr);
            this.fragmentRules.add(fragmentRule);
        }

        for (String key: listRules.keySet()){
            List<Rule> lr = listRules.get(key);
            ListRule listRule = new ListRule();
            listRule.name = key;
            listRule.setRuels(lr);
            this.listRules.add(listRule);
        }

    }


    public List<FragmentRule> getFragmentRules() {
        return fragmentRules;
    }

    public List<ListRule> getListRules() {
        return listRules;
    }

    public List<Rule> getRules() {
        return rules;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
