package com.najva.sdk.event_management.database;

import android.os.AsyncTask;

import com.najva.sdk.R;
import com.najva.sdk.event_management.model.Rule;
import com.najva.sdk.event_management.model.Tag;

import java.util.ArrayList;
import java.util.List;

public class SelectTagTask extends AsyncTask<Integer, Integer, List<Tag>> {

    TagDatabase database;
    private OnTagsLoadListener listener;

    public SelectTagTask(TagDatabase tagDatabase, OnTagsLoadListener listener) {
        this.database = tagDatabase;
        this.listener = listener;
    }

    @Override
    protected List<Tag> doInBackground(Integer... integers) {
        return database.getTags();
    }

    @Override
    protected void onPostExecute(List<Tag> tags) {
        if (tags != null) {
            listener.onTagsLoaded(tags);
        }
    }

    public interface OnTagsLoadListener {
        void onTagsLoaded(List<Tag> tags);
    }
}
