package com.najva.sdk.event_management.database;

import android.os.AsyncTask;

import com.najva.sdk.event_management.model.Rule;
import java.util.List;

public class SelectAllRulesTask extends AsyncTask<Void, Integer, List<Rule>> {

    private TagDatabase database;
    private OnRulesLoadListener listener;

    public SelectAllRulesTask(TagDatabase database, OnRulesLoadListener listener) {

        this.database = database;
        this.listener = listener;
    }

    @Override
    protected List<Rule> doInBackground(Void... voids) {
        return database.getRules();
    }

    @Override
    protected void onPostExecute(List<Rule> rules) {
        if (listener != null)
            listener.onRulesLoaded(rules);
    }

    public interface OnRulesLoadListener {
        void onRulesLoaded(List<Rule> rules);
    }
}
