package com.najva.sdk.event_management.database;

import android.os.AsyncTask;

import com.najva.sdk.event_management.model.Rule;
import com.najva.sdk.event_management.model.Tag;

public class InsertTagTask extends AsyncTask<Tag, Integer, Boolean> {
    private TagDatabase database;

    public InsertTagTask(TagDatabase database) {

        this.database = database;
    }

    @Override
    protected Boolean doInBackground(Tag... tags) {
        for (Tag tag : tags) {
            database.insertTag(tag);
            for (Rule rule : tag.getRules()) {
                database.addRuleForTag(tag, rule);
            }
        }
        return true;
    }
}
