package com.najva.sdk.event_management.clickListener;

import android.util.Log;
import android.view.View;

import com.najva.sdk.event_management.TagManager;
import com.najva.sdk.event_management.model.Rule;

public class OnClickListener implements View.OnClickListener {
    private final Rule rule;
    private final TagManager manager;
    private View.OnClickListener latestOnClickListener;

    public OnClickListener(Rule rule, TagManager manager,View.OnClickListener latestOnClickListener){
        this.rule = rule;
        this.manager = manager;
        this.latestOnClickListener = latestOnClickListener;
    }
    @Override
    public void onClick(View v) {
        Log.d("OnClickListener","on item " + rule.getItemId() + " clicked.");
        if (latestOnClickListener!=null) latestOnClickListener.onClick(v);
        rule.setSatisfied(true);
        manager.updateRule(rule);
    }
}
