package com.najva.sdk.event_management.adapters;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.najva.sdk.event_management.TagManager;
import com.najva.sdk.event_management.view_observer.EventManager;
import com.najva.sdk.event_management.ViewUtils;
import com.najva.sdk.event_management.clickListener.OnClickListener;
import com.najva.sdk.event_management.model.Rule;

import java.util.ArrayList;
import java.util.List;

public class WrapperAdapter extends RecyclerView.Adapter {

    private RecyclerView.Adapter adapter;
    private TagManager tagManager;

    private List<Rule> rules = new ArrayList<>();

    private RecyclerView.AdapterDataObserver observer = new RecyclerView.AdapterDataObserver() {
        @Override
        public void onChanged() {
            notifyDataSetChanged();
        }

        @Override
        public void onItemRangeChanged(int positionStart, int itemCount) {
            notifyItemRangeChanged(positionStart, itemCount);
        }

        @Override
        public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
            notifyItemRangeChanged(positionStart, itemCount, payload);
        }

        @Override
        public void onItemRangeInserted(int positionStart, int itemCount) {
            notifyItemRangeInserted(positionStart, itemCount);
        }

        @Override
        public void onItemRangeRemoved(int positionStart, int itemCount) {
            notifyItemRangeRemoved(positionStart, itemCount);
        }

        @Override
        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            notifyItemRangeRemoved(fromPosition, itemCount);
            notifyItemRangeInserted(toPosition, itemCount);
        }
    };

    public WrapperAdapter(RecyclerView.Adapter adapter, TagManager tagManager) {
        this.adapter = adapter;
        this.tagManager = tagManager;
        adapter.registerAdapterDataObserver(observer);
    }

    public void addRule(Rule rule) {
        rules.add(rule);
    }

    @Override
    public boolean onFailedToRecycleView(@NonNull RecyclerView.ViewHolder holder) {

        return adapter.onFailedToRecycleView(holder);
    }

    @Override
    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        adapter.onAttachedToRecyclerView(recyclerView);
        super.onAttachedToRecyclerView(recyclerView);
    }

    @Override
    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        adapter.onDetachedFromRecyclerView(recyclerView);
        super.onDetachedFromRecyclerView(recyclerView);
    }

    @Override
    public void onViewAttachedToWindow(@NonNull RecyclerView.ViewHolder holder) {
        adapter.onViewAttachedToWindow(holder);
    }

    @Override
    public void onViewDetachedFromWindow(@NonNull RecyclerView.ViewHolder holder) {
        adapter.onViewDetachedFromWindow(holder);
    }

    @Override
    public void onViewRecycled(@NonNull RecyclerView.ViewHolder holder) {
        adapter.onViewRecycled(holder);
    }

    @Override
    public int getItemViewType(int position) {
        return adapter.getItemViewType(position);
    }

    @Override
    public long getItemId(int position) {
        return adapter.getItemId(position);
    }

    @Override
    public void registerAdapterDataObserver(@NonNull RecyclerView.AdapterDataObserver observer) {
        adapter.registerAdapterDataObserver(observer);
        super.registerAdapterDataObserver(observer);
    }

    @Override
    public void unregisterAdapterDataObserver(@NonNull RecyclerView.AdapterDataObserver observer) {
        adapter.unregisterAdapterDataObserver(observer);
        super.unregisterAdapterDataObserver(observer);
    }

    @Override
    public void setHasStableIds(boolean hasStableIds) {
        adapter.setHasStableIds(hasStableIds);
        super.setHasStableIds(hasStableIds);
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder holder = adapter.onCreateViewHolder(parent, viewType);
        for (Rule rule : rules) {
            addClickListener(holder, rule);
        }
        return holder;
    }

    private void addClickListener(RecyclerView.ViewHolder holder, Rule rule) {
        int id = ViewUtils.getId(EventManager.RIdClass, rule.getItemId());
        if (id > 0) {
            try {
                View view = holder.itemView.findViewById(id);
                View.OnClickListener lastClickListener = null;
                if (view.hasOnClickListeners()) {
                    lastClickListener = ViewUtils.getOnClickListenerForView(view);
                }
                view.setOnClickListener(new OnClickListener(rule, tagManager, lastClickListener));
            } catch (Exception e) {
                Log.d("EventManager", "list click listener exception");
            }
        }
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        adapter.onBindViewHolder(holder, position);
    }

    @Override
    public int getItemCount() {
        return adapter.getItemCount();
    }
}
