package com.najva.sdk.event_management;

import android.util.Log;
import android.view.View;

import java.lang.reflect.Field;

public class ViewUtils {
    public static View.OnClickListener getOnClickListenerForView(View view) {
        View.OnClickListener retrievedListener = null;
        String viewStr = "android.view.View";
        String lInfoStr = "android.view.View$ListenerInfo";


        try {
            Field listenerField = Class.forName(viewStr).getDeclaredField("mListenerInfo");
            Object listenerInfo;

            listenerField.setAccessible(true);
            listenerInfo = listenerField.get(view);

            Field clickListenerField = Class.forName(lInfoStr).getDeclaredField("mOnClickListener");

            if (listenerInfo != null) {
                retrievedListener = (View.OnClickListener) clickListenerField.get(listenerInfo);
            }
        } catch (NoSuchFieldException ex) {
            Log.e("Reflection", "No Such Field.");
        } catch (IllegalAccessException ex) {
            Log.e("Reflection", "Illegal Access.");
        } catch (ClassNotFoundException ex) {
            Log.e("Reflection", "Class Not Found.");
        }

        return retrievedListener;
    }

    public static int getId(Class cls, String itemId) {
        if (cls == null) return -1;
        try {
            Field field = cls.getField(itemId);
            Log.d("EventManager", "field for id " + itemId + ": " + field.toString());
            return field.getInt(null);
        } catch (NoSuchFieldException e) {
            Log.d("EventManager", "itemId not found");
        } catch (IllegalAccessException e) {
            Log.d("EventManager", "field is not static");
        }
        return -1;
    }

    public static int getListId(Class cls, String itemId) {
        Log.i("EventManager",itemId);
        String listId = itemId.split("\\.")[0];
        return getId(cls, listId);
    }
}
