package com.najva.sdk.event_management;

import android.content.Context;

import androidx.work.WorkManager;

import com.najva.sdk.event_management.database.SelectAllRulesTask;
import com.najva.sdk.event_management.database.SelectTagTask;
import com.najva.sdk.event_management.database.TagDatabase;
import com.najva.sdk.event_management.model.Rule;

public class TagManager {
    private TagDatabase database;
    private WorkManager workManager;

    public TagManager(Context context) {
        database = new TagDatabase(context);
        workManager = WorkManager.getInstance();
    }

    public void getTags(SelectTagTask.OnTagsLoadListener listener) {
        new SelectTagTask(database, listener).execute();
    }

    public void getRules(SelectAllRulesTask.OnRulesLoadListener listener) {
        new SelectAllRulesTask(database, listener).execute();
    }

    public void updateRule(Rule rule) {
        database.updateRule(rule);
        //TODO send request to server.
    }
}

