package com.najva.sdk.core.utils;

import android.content.Context;
import androidx.annotation.NonNull;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;

public class VolleySingleton {

    private static VolleySingleton volleySingleton;
    private RequestQueue queue;
    private static final int INITIAL_TIMEOUT_MS = 60 * 1000;
    private static final int MAX_NUM_RETRIES = 3;
    private Object tag = new Object();

    public static VolleySingleton getInstance(@NonNull Context context){
        if (volleySingleton == null)
            volleySingleton = new VolleySingleton(context);
        return volleySingleton;
    }

    private VolleySingleton(Context context){
        queue = Volley.newRequestQueue(context);
    }


    public void add(Request request){
        add(tag,request);
    }

    public void add(Object tag,Request request){
        request.setRetryPolicy(new DefaultRetryPolicy(
                INITIAL_TIMEOUT_MS,
                MAX_NUM_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setTag(tag);

        queue.add(request);
    }

    public void cancelAll(){
        cancelAll(tag);
    }
    public void cancelAll(Object tag){
        queue.cancelAll(tag);
    }




}
