package com.najva.sdk.core.utils;

import android.content.Context;

import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;

import com.najva.sdk.core.works.FormRequestWorker;

import java.util.Map;

import static com.najva.sdk.core.utils.StaticFields.ACTIVE_USER;
import static com.najva.sdk.core.utils.StaticFields.INTERVAL_ACTION;

public class NotificationActionHandler {


    public static void handleNajvaConfig(Context context, Map<String, String> date,String messageId) {
        if (date == null) return;
        assert date.get(StaticFields.SDK_ACTION_TYPE) != null;
        assert date.get(StaticFields.SDK_ACTION) != null;
        switch (date.get(StaticFields.SDK_ACTION_TYPE)) {
            case INTERVAL_ACTION:
                Configuration.writeInterval(context, Long.parseLong(date.get(StaticFields.SDK_ACTION)));
                break;
            case ACTIVE_USER:
                checkActiveUser(context,messageId);
                break;
        }
    }

    private static void checkActiveUser(Context context,String messageId) {
        OneTimeWorkRequest requestWorker = new FormRequestWorker.Builder(context)
                .addParam(StaticFields.NOTIFICATION_ID,messageId)
                .addParam(StaticFields.NAJVA_TOKEN,CookieManager.getInstance(context).getCookies())
                .setUrl(ApiInfo.ACTIVE_USER_URL.getValue())
                .build();
        WorkManager.getInstance().enqueue(requestWorker);
    }
}
