package com.najva.sdk.core.utils;

import android.content.Context;
import android.util.Log;


public class CookieManager {
    public static final String TAG = "CookieManager";
    public static CookieManager getInstance(Context context) {
        return new CookieManager(context);
    }

    private Context context;

    private CookieManager(Context context) {
        this.context = context;
    }

    public void saveCookie(String cookies) {
        //activity or context may be null after app closes by user or any other cause
        Log.d(TAG, "saving cookies: " + cookies);
        if (context == null) return;

        if (cookies != null && cookies.contains("najva_token")) {
            int idx = cookies.indexOf("najva_token=");
            int offset_idx = 0;
            while (cookies.charAt(idx + offset_idx) != ';') {
                offset_idx++;
            }
            String najva_token = cookies.substring(idx, idx + offset_idx + 1);
            updateCookie(najva_token);
        }
    }

    private void updateCookie(String cookie) {
        Log.d(TAG,cookie);
        FileManager.writeToFile(context, Parameter.NAJVA_COOKIE_FILE_NAME.getValue(), cookie);
    }

    public String getCookies() {
        String cookies = FileManager.readFromFile(context, Parameter.NAJVA_COOKIE_FILE_NAME.getValue());
        Log.d(TAG, "cookies: " + cookies);
        return cookies;
    }
}
