package com.najva.sdk.in_app_messaging.view;


import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.os.CountDownTimer;
import android.os.Handler;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;

import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.najva.sdk.R;
import com.najva.sdk.in_app_messaging.NajvaImageLoader;
import com.najva.sdk.in_app_messaging.model.ButtonProperty;
import com.najva.sdk.in_app_messaging.model.CloseButton;
import com.najva.sdk.in_app_messaging.model.CloseButtonType;
import com.najva.sdk.in_app_messaging.model.ImageProperty;
import com.najva.sdk.in_app_messaging.model.TextProperty;
import com.najva.sdk.in_app_messaging.presenter.BannerPresenter;

import androidx.cardview.widget.CardView;


public class BannerPopup implements BannerPopupInterface {
    private PopupWindow popupWindow;
    private View popupView;
    private static final int MATCH_PARENT = ViewGroup.LayoutParams.MATCH_PARENT;
    private static final int WRAP_CONTENT = ViewGroup.LayoutParams.WRAP_CONTENT;
    private int resourceId;
    private String CLOSE_RIPPLE_COLOR = "#ECEFF1";

    @Override
    public PopupOption prepareView(InAppType type) {
        PopupOption option = new PopupOption();
        if (type == InAppType.HEADER) {
            resourceId = R.layout.baner_item;
            option.setHeight(WRAP_CONTENT)
                    .setWidth(MATCH_PARENT)
                    .setFrameColor(0x00000000)
                    .setGravity(Gravity.TOP);
        } else {
            // this will not happen anyway
            option.setHeight(WRAP_CONTENT)
                    .setWidth(MATCH_PARENT)
                    .setGravity(Gravity.BOTTOM);
        }
        return option;
    }

    @Override
    public void bindInApp(Context context, int backgroundColor) {
        popupView = LayoutInflater.from(context).inflate(resourceId, null, false);
        CardView cardView = popupView.findViewById(R.id.root_card);
        cardView.setCardBackgroundColor(backgroundColor);
        Log.d("BannerPopup", "bindInApp: ");
    }

    @Override
    public void bindTitle(TextProperty title) {
        Log.d("BannerPopup", "bindTitle: " + title.getText());
        TextView textView_title = popupView.findViewById(R.id.text_view_title);
        if (title.isVisibility()) {
            textView_title.setVisibility(View.VISIBLE);
            textView_title.setText(title.getText());
            textView_title.setTextColor(title.getColor());
        } else {
            textView_title.setVisibility(View.GONE);
        }
    }

    @Override
    public void bindPrimaryButton(ButtonProperty primaryButton) {
        CardView card_primary = popupView.findViewById(R.id.button_left);
        TextView card_text = popupView.findViewById(R.id.button_left_text);
        if (primaryButton.isVisibility()) {
            card_text.setText(primaryButton.getText());
            card_text.setTextColor(primaryButton.getTextColor());
            card_text.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    userDismiss();
                }
            });
        } else {
            card_primary.setVisibility(View.GONE);
        }
    }

    @Override
    public void bindSecondaryButton(ButtonProperty secondaryButton) {
        CardView card_secondary = popupView.findViewById(R.id.button_right);
        TextView card_text = popupView.findViewById(R.id.button_right_text);
        if (secondaryButton.isVisibility()) {
            card_text.setText(secondaryButton.getText());
            card_text.setTextColor(secondaryButton.getTextColor());
            card_text.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    userDismiss();
                }
            });
        } else {
            card_secondary.setVisibility(View.GONE);
        }

    }

    @Override
    public void bindImage(Context context, ImageProperty image) {
        ImageView imageView = popupView.findViewById(R.id.image_view);
        if (image.isVisibility()) {
            imageView.setImageBitmap(NajvaImageLoader.getInstance(context).getBitmap(imageView.getLayoutParams().width, imageView.getLayoutParams().height));
        } else {
            imageView.setVisibility(View.GONE);
        }
    }

    @Override
    public void show(final PopupOption option, final Activity activity, CloseButton closeButton) {
        final View parent = activity.findViewById(android.R.id.content).getRootView();
        popupWindow = new PopupWindow(popupView, option.getWidth(), option.getHeight());
        ImageView imageButton_close = popupView.findViewById(R.id.button_close);
        imageButton_close.setImageDrawable(getDrawableCloseIcon(closeButton, activity));
        imageButton_close.setColorFilter(closeButton.getColor());

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            popupWindow.setElevation(20f);
        }
        imageButton_close.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                userDismiss();
            }
        });

        popupWindow.setAnimationStyle(R.style.Fade);


        new CountDownTimer(5000, 500) {
            boolean flag = true;

            @Override
            public void onTick(long millisUntilFinished) {
                if (parent.getWindowToken() != null && flag) {
                    popupWindow.showAtLocation(parent, option.getGravity(), 0, 0);
                    flag = false;
                }
            }

            @Override
            public void onFinish() {
                if (parent.getWindowToken() != null && flag) {
                    popupWindow.showAtLocation(parent, option.getGravity(), 0, 0);
                }
            }
        }.start();


    }

    @Override
    public void dismiss() {
        if (popupWindow != null) {
            popupWindow.dismiss();
        }
    }

    private void userDismiss() {
        if (popupWindow != null) {
            popupWindow.dismiss();
            BannerPresenter.inAppClosed();
        }
    }

    private Drawable getDrawableCloseIcon(CloseButton closeButton, Activity activity) {
        if (closeButton.getType() == CloseButtonType.CLOSE) {
            return activity.getResources().getDrawable(R.drawable.ic_close);
        } else if (closeButton.getType() == CloseButtonType.CLOSE_CIRCLE) {
            return activity.getResources().getDrawable(R.drawable.ic_close_frame);
        } else if (closeButton.getType() == CloseButtonType.CLOSE_WINDOW) {
            return activity.getResources().getDrawable(R.drawable.ic_close_window);
        }
        return null;
    }
}
