package com.najva.sdk.in_app_messaging;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.LruCache;

import androidx.annotation.Nullable;

import com.android.volley.VolleyError;
import com.android.volley.toolbox.ImageLoader;
import com.najva.sdk.R;
import com.najva.sdk.core.utils.Logger;
import com.najva.sdk.core.utils.VolleySingleton;

public class NajvaImageLoader {
    private static NajvaImageLoader instance;
    private ImageLoader imageLoader;
    private String imageUrl;
    private int placeHolder;
    private LruCache<String, Bitmap> mCache;
    private Bitmap bitmap;

    public static NajvaImageLoader getInstance(Context context) {
        if (instance == null) {
            instance = new NajvaImageLoader(context);
        }
        return instance;
    }

    private NajvaImageLoader(Context context) {
        bitmap = BitmapFactory.decodeResource(context.getResources(), R.drawable.image_placeholder);
        mCache = new LruCache<>(10);
        imageLoader = new ImageLoader(VolleySingleton.getInstance(context).getQueue(), new ImageLoader.ImageCache() {
            @Override
            public Bitmap getBitmap(String url) {
                return mCache.get(url);
            }

            @Override
            public void putBitmap(String url, Bitmap bitmap) {
                mCache.put(url, bitmap);
            }
        });
    }

    public NajvaImageLoader load(String url) {
        this.imageUrl = url;
        return this;
    }

    public NajvaImageLoader placeHolder(int drawableResId) {
        this.placeHolder = drawableResId;
        return this;
    }


    public void into(final OnCompleteLoadImage completeLoadImage) {
        imageLoader.get(imageUrl, new ImageLoader.ImageListener() {
            @Override
            public void onResponse(ImageLoader.ImageContainer response, boolean isImmediate) {
                if (response.getBitmap() != null) {
                    bitmap = response.getBitmap();
                    completeLoadImage.onSuccess();
                    Logger.i("NajvaLoader", "onResponse: success");
                }

            }

            @Override
            public void onErrorResponse(VolleyError error) {
                completeLoadImage.onFailure(error, imageUrl);
                Logger.d("NajvaLoader", "onErrorResponse: " + error);
            }
        }, 1024, 1024);
    }

    @Nullable
    public Bitmap getBitmap(int width, int height) {
        if (width != -1 && height != -1) {
            return Bitmap.createScaledBitmap(bitmap, width, height, false);
        }
        return bitmap;
    }


    public interface OnCompleteLoadImage {
        void onSuccess();

        void onFailure(VolleyError error, String url);
    }

}
