package com.najva.sdk.utils;

import android.content.pm.PackageItemInfo;

/**
 * created by shayan4shayan
 * <p>
 * this is a singleton class to access android-manifest metadata
 */
public class MetaDataUtils {
    /**
     * global name for api-key that using as name of meta-data in AndroidManifest.xml
     */
    private static final String META_DATA_API_KEY = "com.najva.sdk.metadata.API_KEY";

    /**
     * global name for website-id that using as name of meta-data in AndroidManifest.xml
     */
    private static final String META_DATA_WEBSITE_ID = "com.najva.sdk.metadata.WEBSITE_ID";

    /**
     * private singleton instance
     */
    private static MetaDataUtils instance;

    public static MetaDataUtils getInstance(PackageItemInfo info) {
        if (instance == null) instance = new MetaDataUtils(info);

        return instance;
    }

    /**
     * with this variable we can gain access to meta-data tags
     */
    private PackageItemInfo mApplicationInfo;

    /**
     * private constructor
     *
     * @param info to gain access to meta-data tags in android-manifest file
     */
    private MetaDataUtils(PackageItemInfo info) {
        mApplicationInfo = info;
    }

    /**
     * uses mApplicationInfo metadata to get access to meta-data tags in android manifest
     *
     * @return value of meta-data with META_DATA_API_KEY name
     */
    public String getApiKey() {
        String apiKey = mApplicationInfo.metaData.getString(META_DATA_API_KEY);
        if (apiKey == null) throw new RuntimeException("Error read MetaData : did you forget to add MetaData to manifest?");
        return apiKey;
    }

    /**
     * uses mApplicationInfo's meta data to get access to meta-data tags in android manifest
     *
     * @return value of meta-data with META_DATA_WEBSITE_ID name
     */
    public int getWebsiteId() {
        int websiteId = mApplicationInfo.metaData.getInt(META_DATA_WEBSITE_ID);
        if (websiteId == 0) throw new RuntimeException("Error read MetaData : did you forget to add MetaData to manifest?");
        return websiteId;
    }

}