package com.najva.sdk.runnables;

import android.content.Context;
import android.content.Intent;

import com.najva.sdk.Najva;
import com.najva.sdk.NajvaClient;
import com.najva.sdk.NajvaClientReceiver;
import com.najva.sdk.NajvaRunnable;
import com.najva.sdk.UserSubscriptionListener;
import com.najva.sdk.core.utils.StaticFields;

public class NajvaSubscriberTokenHandler implements NajvaRunnable {

    public static void sendBroadcast(Context context, Intent intent) {
        Intent sendIntent = new Intent(NajvaClientReceiver.ACTION);
        sendIntent.putExtra(StaticFields.ACTION, StaticFields.EVENT_TYPE_TOKEN);
        sendIntent.putExtras(intent);
        context.sendBroadcast(sendIntent);
    }

    @Override
    public void run(Intent data) {
        String token = data.getStringExtra(StaticFields.NAJVA_TOKEN);
        if (NajvaClient.configuration.getUserSubscriptionListener() != null) {
            NajvaClient.configuration.getUserSubscriptionListener().onUserSubscribed(token);
        }
    }
}
