package com.najva.sdk.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;

import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;

import com.android.volley.Request;
import com.najva.sdk.core.utils.ApiInfo;
import com.najva.sdk.core.utils.StaticFields;
import com.najva.sdk.core.works.FormRequestWorker;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;

public class UninstallPackageReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        String packageName = intent.getData().getEncodedSchemeSpecificPart();
        PackageManager packageManager = context.getPackageManager();
        String appLabel = "";
        try {
            appLabel = (String) packageManager.getApplicationLabel(packageManager.getApplicationInfo(packageName, PackageManager.GET_META_DATA));
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        removePackageInfoRequest(context, packageName, appLabel);
    }

    private void removePackageInfoRequest(final Context context, final String packageName, final String appLabel) {
        OneTimeWorkRequest oneTimeWorkRequest = new FormRequestWorker.Builder(context)
                .setUrl(ApiInfo.CHANGE_DEVICE_INFO.getValue())
                .setMethod(Request.Method.POST)
                .setParams(getPackageInfoParams(packageName,appLabel))
                .build();

        WorkManager.getInstance(context).enqueue(oneTimeWorkRequest);
    }

    private HashMap<String, String> getPackageInfoParams(String packageName, String appLabel) {
        HashMap<String, String> params = new HashMap<>();

        String encodedAppLable = appLabel;
        try {
            encodedAppLable = URLEncoder.encode(encodedAppLable, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        params.put(StaticFields.OPERATION, StaticFields.OPERATION_REMOVE);
        params.put(StaticFields.PACKAGE_NAME, packageName);
        params.put(StaticFields.APP_LABEL, encodedAppLable);

        return params;
    }
}
