package com.najva.sdk.push_notification.service;

import androidx.annotation.NonNull;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.najva.sdk.core.utils.Logger;
import com.najva.sdk.push_notification.NajvaPushNotificationHandler;


/**
 * Created by sina on 9/16/2018.
 */
public class NajvaMessagingService extends FirebaseMessagingService {
    public static final String TAG = "NajvaMessagingService";

    @Override
    public void onCreate() {
        super.onCreate();
        Logger.d(TAG,"Najva messaging service started");
    }

    @Override
    public void onMessageReceived(@NonNull RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        Logger.i(TAG, "new notification received");
        NajvaPushNotificationHandler.handleMessage(getApplicationContext(), remoteMessage);
    }

    @Override
    public void onNewToken(String token) {
        super.onNewToken(token);
        Logger.i(TAG, "onNewToken: " + token);
        NajvaPushNotificationHandler.handleNewToken(getApplicationContext());
    }
}
