package com.najva.sdk.push_notification.handlers.compat;

import android.content.Context;
import android.graphics.Bitmap;
import android.widget.ImageView;

import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;

import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.ImageRequest;
import com.najva.sdk.NajvaClient;
import com.najva.sdk.R;
import com.najva.sdk.core.utils.StaticFields;
import com.najva.sdk.core.utils.VolleySingleton;

import java.util.Map;

public class ImageNotificationHandlerCompat extends NormalNotificationHandlerCompat {
    public ImageNotificationHandlerCompat(Context context, Map<String, String> data, String messageId) {
        super(context, data, messageId);
    }
    @Override
    public void updateBuilderCompat(NotificationCompat.Builder builder) {
        builder.setAutoCancel(true);
        builder.setSmallIcon(NajvaClient.configuration.getNotificationSmallIcon());

        builder.setColorized(true);
        builder.setColor(ContextCompat.getColor(context, R.color.najva));
        builder.setLights(ContextCompat.getColor(context, R.color.najva), 500, 500);

        builder.setContentTitle(data.get(StaticFields.TITLE));
        builder.setContentText(data.get(StaticFields.BODY));

        downloadImageIconCompat();
    }

    private void downloadImageIconCompat() {
        ImageRequest imageRequest = new ImageRequest(data.get(StaticFields.ICON), new Response.Listener<Bitmap>() {
            @Override
            public void onResponse(Bitmap response) {
                if (response != null) {
                    builderCompat.setLargeIcon(response);

                    downloadImageCompat(response);
                }
            }
        }, 1200, 1200, ImageView.ScaleType.CENTER_CROP, Bitmap.Config.ARGB_8888, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                VolleyLog.wtf(error.getMessage(), "utf-8");
            }
        });

        VolleySingleton.getInstance(context).add(imageRequest);
    }

    private void downloadImageCompat(final Bitmap icon) {
        ImageRequest imageRequest = new ImageRequest(data.get(StaticFields.IMAGE), new Response.Listener<Bitmap>() {
            @Override
            public void onResponse(Bitmap response) {
                if (response != null) {
                    builderCompat.setStyle(new NotificationCompat.BigPictureStyle()
                            .bigLargeIcon(icon)
                            .bigPicture(response)
                            .setBigContentTitle(data.get(StaticFields.TITLE))
                            .setSummaryText(data.get(StaticFields.BODY))
                    );

                    sendNotificationCompat();
                }
            }
        }, 1200, 1200, ImageView.ScaleType.CENTER_CROP, Bitmap.Config.ARGB_8888, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                VolleyLog.wtf(error.getMessage(), "utf-8");
            }
        });

        VolleySingleton.getInstance(context).add(imageRequest);
    }
}
