package com.najva.sdk.push_notification.handlers;

import android.app.Notification;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Build;

import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;

import com.najva.sdk.NajvaClient;
import com.najva.sdk.R;
import com.najva.sdk.core.utils.ImageUtils;
import com.najva.sdk.core.utils.StaticFields;

import java.util.Map;

public class NormalNotificationHandler extends BaseNotificationHandler {

    public NormalNotificationHandler(Context context, Map<String, String> data, String messageId) {
        super(context, data, messageId);
    }

    @RequiresApi(api = Build.VERSION_CODES.O)
    @Override
    public void updateBuilder(Notification.Builder builder) {
        builder.setAutoCancel(true);
        setNotificationSmallIcon(builder);

        builder.setColorized(true);
        builder.setColor(ContextCompat.getColor(context,R.color.najva));
        builder.setLights(ContextCompat.getColor(context,R.color.najva),500,500);

        builder.setContentTitle(data.get(StaticFields.TITLE));
        builder.setContentText(data.get(StaticFields.BODY));

        sendNotification();
    }

    void setNotificationSmallIcon(Notification.Builder builder) {
        if (NajvaClient.configuration.getNotificationSmallIcon() != R.drawable.najva_notification_icon){
            builder.setSmallIcon(NajvaClient.configuration.getNotificationSmallIcon());
            return;
        }
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
            Drawable foregroundIcon = getForegroundIcon();
            if (foregroundIcon != null){
                Icon icon = Icon.createWithBitmap(ImageUtils.drawableToBitmap(foregroundIcon));
                builder.setSmallIcon(icon);
                return;
            }
        }
        builder.setSmallIcon(getApplicationIcon());
    }
}
