package com.najva.sdk.push_notification.handlers;

import android.app.Notification;
import android.content.Context;
import android.os.Build;

import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;

import com.najva.sdk.core.utils.StaticFields;

import java.util.Map;

public class BigTextNotificationHandler extends NormalNotificationHandler {
    public BigTextNotificationHandler(Context context, Map<String, String> data, String messageId) {
        super(context, data, messageId);
    }

    @RequiresApi(api = Build.VERSION_CODES.O)
    @Override
    public void updateBuilder(Notification.Builder builder) {
        builder.setStyle(new Notification.BigTextStyle()
            .bigText(data.get(StaticFields.BODY))
                .setBigContentTitle(data.get(StaticFields.TITLE))
                .setSummaryText(data.get(StaticFields.SUMMARY))
        );
        super.updateBuilder(builder);
    }

    private String getSummary() {
        String body = data.get(StaticFields.BODY);
        assert body!=null;
        if (body.length()>30){
            return body.substring(27) +"...";
        }
        return body;
    }
}
