package com.najva.sdk.in_app_messaging.view;


import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.RoundedBitmapDrawable;
import androidx.core.graphics.drawable.RoundedBitmapDrawableFactory;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;

import android.os.Handler;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;

import com.google.android.material.button.MaterialButton;
import com.najva.sdk.R;
import com.najva.sdk.in_app_messaging.NajvaImageLoader;
import com.najva.sdk.in_app_messaging.model.ButtonProperty;
import com.najva.sdk.in_app_messaging.model.CloseButton;
import com.najva.sdk.in_app_messaging.model.CloseButtonType;
import com.najva.sdk.in_app_messaging.model.ImageProperty;
import com.najva.sdk.in_app_messaging.model.InApp;
import com.najva.sdk.in_app_messaging.model.TextProperty;
import com.najva.sdk.in_app_messaging.presenter.InAppPresenter;

/**
 * A simple {@link Fragment} subclass.
 */
public class InAppFragment extends Fragment implements InAppViewInterface {

    public static final String TAG = "InAppFragment";
    private static final int MATCH_PARENT = ViewGroup.LayoutParams.MATCH_PARENT;
    private static final int WRAP_CONTENT = ViewGroup.LayoutParams.WRAP_CONTENT;
    private int resourceId;

    private InAppPresenter presenter;
    private InApp inAppModel;

    private View view;
    private TextView textView_title;
    private TextView textView_description;
    private Button button_primary;
    private Button button_secondary;
    private ImageView imageButton_close;
    private ImageView imageView;
    private String IMAGE_RIPPLE_COLOR = "#CFD8DC";
    private String CLOSE_RIPPLE_COLOR = "#ECEFF1";

    private FrameLayout frameLayout;
    private View popupView;
    private PopupWindow popupWindow;
    private InAppFragmentCallBack callBack;


    public static InAppFragment newInstance(Bundle inApp) {
        InAppFragment fragment = new InAppFragment();
        fragment.setArguments(inApp);
        return fragment;
    }


    public InAppFragment() {
        // Required empty public constructor

    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        callBack = (InAppFragmentCallBack) context;
    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (callBack != null)
            callBack = null;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        inAppModel = (InApp) getArguments().getSerializable(InAppActivity.MODEL);

        if (inAppModel == null) {
            getActivity().finish();
        }

        presenter = InAppPresenter.getInstance(inAppModel, this);
        presenter.handleInApp();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        //  Inflate the layout for this fragment
        view = inflater.inflate(R.layout.fragment_in_app, container, false);
        return view;
    }


    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        frameLayout = view.findViewById(R.id.in_app_frame_layout);
        popupView = getLayoutInflater().inflate(resourceId, frameLayout, false);
    }


    @Override
    public void show(PopupOption option, CloseButton closeButton) {
        view.setBackgroundColor(option.getFrameColor());
        popupWindow = new PopupWindow(popupView, option.getWidth(), option.getHeight());

        if (option.hasCloseBtn()) {
            imageButton_close = popupView.findViewById(R.id.button_close);
            imageButton_close.setColorFilter(closeButton.getColor());
            imageButton_close.setImageDrawable(getDrawableCloseIcon(closeButton));
            imageButton_close.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    closePopup();

                }
            });
        } else {
            popupView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    closePopup();
                }
            });
            frameLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    closePopup();
                }
            });
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            popupWindow.setElevation(20f);
        }
        popupWindow.setAnimationStyle(R.style.Fade);
        popupWindow.showAtLocation(frameLayout, option.getGravity(), 0, 0);
    }

    private Drawable getDrawableCloseIcon(CloseButton closeButton) {
        if(closeButton.getType() == CloseButtonType.CLOSE ){
            return getResources().getDrawable(R.drawable.ic_close);
        }else if (closeButton.getType() == CloseButtonType.CLOSE_CIRCLE){
            return getResources().getDrawable(R.drawable.ic_close_frame);
        }else if(closeButton.getType() == CloseButtonType.CLOSE_WINDOW){
            return getResources().getDrawable(R.drawable.ic_close_window);
        }
        return null;
    }

    private void closePopup() {
        if (popupWindow != null) {
            popupWindow.dismiss();
        }
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                callBack.finishActivity();
            }
        }, 300);

    }

    @Override
    public void bindInApp() {
        View inAppRootView = popupView.getRootView().findViewById(R.id.root_view);
        if (inAppRootView != null)
            inAppRootView.setBackgroundColor(inAppModel.getBackgroundColor());
    }

    @Override
    public void bindTitle(TextProperty title) {
        Log.d(TAG, "bindTitle: ");
        textView_title = popupView.findViewById(R.id.text_view_title);
        if (title.isVisibility()) {
            textView_title.setVisibility(View.VISIBLE);
            textView_title.setText(title.getText());
            textView_title.setTextColor(title.getColor());
        } else {
            textView_title.setVisibility(View.GONE);
        }
    }

    @Override
    public void bindDescription(TextProperty description) {
        textView_description = popupView.findViewById(R.id.text_view_description);
        if (description.isVisibility()) {
            textView_description.setVisibility(View.VISIBLE);
            textView_description.setText(description.getText());
            textView_description.setTextColor(description.getColor());
        } else {
            textView_description.setVisibility(View.GONE);
        }
    }

    @Override
    public void bindPrimaryButton(final ButtonProperty primaryButton) {
        button_primary = popupView.findViewById(R.id.button_right);
        if (primaryButton.isVisibility()) {
            button_primary.setVisibility(View.VISIBLE);
            button_primary.setText(primaryButton.getText());
            button_primary.setBackgroundColor(primaryButton.getBackgroundColor());
            button_primary.setBackgroundTintList(new ColorStateList(primaryButton.getState(), new int[]{primaryButton.getBackgroundColor()}));
            button_primary.setTextColor(primaryButton.getTextColor());
            button_primary.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent = new Intent(Intent.ACTION_VIEW);
                    intent.setData(Uri.parse(primaryButton.getAction()));
                    startActivity(intent);
                    callBack.finishActivity();
                }
            });
        } else {
            button_primary.setVisibility(View.GONE);
        }
    }

    @Override
    public void bindSecondaryButton(final ButtonProperty secondaryButton) {
        button_secondary = popupView.findViewById(R.id.button_left);
        if (secondaryButton.isVisibility()) {
            button_secondary.setVisibility(View.VISIBLE);
            button_secondary.setText(secondaryButton.getText());
            button_secondary.setBackgroundColor(secondaryButton.getBackgroundColor());
            button_secondary.setTextColor(secondaryButton.getTextColor());
            button_secondary.setBackgroundTintList(new ColorStateList(secondaryButton.getState(), new int[]{secondaryButton.getBackgroundColor()}));
            button_secondary.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent = new Intent(Intent.ACTION_VIEW);
                    intent.setData(Uri.parse(secondaryButton.getAction()));
                    startActivity(intent);
                    callBack.finishActivity();
                }
            });
        } else {
            button_secondary.setVisibility(View.GONE);
        }
    }

    @Override
    public void bindImage(final ImageProperty image, PopupOption option) {
        imageView = popupView.findViewById(R.id.image_view);
        if (image.isVisibility()) {
            imageView.setVisibility(View.VISIBLE);
            Log.d(TAG, "bindImage: " + imageView.getLayoutParams().height);
            Bitmap bitmap = NajvaImageLoader.getInstance(getActivity()).getBitmap(imageView.getLayoutParams().width, imageView.getLayoutParams().height);
            RippleDrawable rippledImage = null;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                rippledImage = new RippleDrawable(ColorStateList.valueOf(Color.parseColor(IMAGE_RIPPLE_COLOR)), new BitmapDrawable(getResources(), bitmap), null);
                imageView.setImageDrawable(rippledImage);
            } else {
                imageView.setImageBitmap(bitmap);
            }


            imageView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent = new Intent(Intent.ACTION_VIEW);
                    intent.setData(Uri.parse(image.getAction()));
                    startActivity(intent);
                    callBack.finishActivity();
                }
            });

        } else {
            imageView.setVisibility(View.GONE);
        }
        presenter.onBindImage();
    }

    @Override
    public PopupOption prepareView(InAppType type) {
        PopupOption option = new PopupOption();
        switch (type) {
            case FULL_SCREEN:
                resourceId = R.layout.full_screen_item;
                option.setHeight(MATCH_PARENT)
                        .setWidth(MATCH_PARENT)
                        .setGravity(Gravity.CENTER)
                        .setFrameColor(0x80000000)
                        .setHasCloseBtn(true);
                break;

            case MODAL:
                resourceId = R.layout.modal_item;
                option.setHeight(MATCH_PARENT)
                        .setWidth(MATCH_PARENT)
                        .setFrameColor(0x80000000)
                        .setGravity(Gravity.CENTER)
                        .setHasCloseBtn(true);
                break;
            case IMAGE_ONLY:
                resourceId = R.layout.image_item;
                option.setHeight(WRAP_CONTENT)
                        .setWidth(MATCH_PARENT)
                        .setFrameColor(0x80000000)
                        .setGravity(Gravity.CENTER)
                        .setHasCloseBtn(false);
                break;
        }

        return option;

    }


    @Override
    public void onStop() {
        super.onStop();
        if (popupWindow != null)
            popupWindow.dismiss();
    }


    interface InAppFragmentCallBack {
        void finishActivity();
    }

    @Override
    public void onResume() {
        super.onResume();
        presenter.resumedFragment();
    }


}
