package com.najva.sdk.in_app_messaging.view;

import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.widget.Toast;

import com.najva.sdk.R;
import com.najva.sdk.in_app_messaging.InAppMessagingCallBack;
import com.najva.sdk.in_app_messaging.model.InApp;
import com.najva.sdk.in_app_messaging.presenter.InAppPresenter;

public class InAppActivity extends AppCompatActivity implements InAppFragment.InAppFragmentCallBack {

    public static final String MODEL = "InAppActivity.model";
    private InAppFragment inAppFragment;
    private static InAppMessagingCallBack callBack;

    public static Intent newIntent(Context context, InApp app, InAppMessagingCallBack callBack) {
        InAppActivity.callBack = callBack;
        Intent intent = new Intent(context, InAppActivity.class);
        intent.putExtra(MODEL, app);
        return intent;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_in_app);
        this.setFinishOnTouchOutside(false);
        FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
        for (Fragment f : getSupportFragmentManager().getFragments()) {
            transaction.remove(f);
        }
        transaction.commitNow();


        inAppFragment = InAppFragment.newInstance(getIntent().getExtras());



    }

    @Override
    protected void onResume() {
        super.onResume();
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                if (getSupportFragmentManager().getFragments().size() == 0) {
                    getSupportFragmentManager().beginTransaction()
                            .add(R.id.container, inAppFragment)
                            .addToBackStack("najva")
                            .commit();

                }

            }
        },100);


    }


    @Override
    public void onBackPressed() {
        super.onBackPressed();
        finish();
    }


    @Override
    public void finishActivity() {
        finish();
        overridePendingTransition(R.anim.fade_in,R.anim.fade_out);
    }

    @Override
    protected void onStop() {
        super.onStop();
        callBack.inAppWasShown();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }
}
