package com.najva.sdk.in_app_messaging.presenter;

import android.util.Log;


import com.najva.sdk.in_app_messaging.model.InApp;

import com.najva.sdk.in_app_messaging.view.InAppFragment;
import com.najva.sdk.in_app_messaging.view.PopupOption;


public class InAppPresenter implements InAppPresenterInterface {
    private InApp inAppModel;
    private InAppFragment inAppView;
    public static final String TAG = "InAppPresenter";
    private PopupOption option;

    public static InAppPresenter getInstance(InApp inApp, InAppFragment view) {
        return new InAppPresenter(inApp, view);
    }

    private InAppPresenter(InApp inApp, InAppFragment view) {
        this.inAppModel = inApp;
        this.inAppView = view;
    }

    public void handleInApp() {
        option = inAppView.prepareView(inAppModel.getType());
    }

    private void bindPopup() {
        Log.d(TAG, "bindPopup: ");

        inAppView.bindInApp();

        if (inAppModel.getTitle().isAvailable())
            inAppView.bindTitle(inAppModel.getTitle());

        if (inAppModel.getDescription().isAvailable())
            inAppView.bindDescription(inAppModel.getDescription());

        if (inAppModel.getButtonPrimary().isAvailable())
            inAppView.bindPrimaryButton(inAppModel.getButtonPrimary());

        if (inAppModel.getButtonSecondary().isAvailable())
            inAppView.bindSecondaryButton(inAppModel.getButtonSecondary());

            inAppView.bindImage(inAppModel.getImage(),option);
    }

    private void displayPopup() {
        inAppView.show(option,inAppModel.getCloseButton());
    }

    @Override
    public void onBindImage() {
        displayPopup();
    }

    @Override
    public void resumedFragment() {
        bindPopup();
    }


}
