package com.najva.sdk.in_app_messaging.presenter;

import android.app.Activity;
import android.util.Log;

import com.najva.sdk.in_app_messaging.InAppMessagingCallBack;
import com.najva.sdk.in_app_messaging.model.InApp;
import com.najva.sdk.in_app_messaging.model.InAppState;
import com.najva.sdk.in_app_messaging.view.BannerPopup;
import com.najva.sdk.in_app_messaging.view.PopupOption;

public class BannerPresenter implements BannerPresenterInterface {

    private  Activity currentActivity;
    private final InApp inApp;
    private BannerPopup popup;
    private PopupOption option;
    private static InAppState state = InAppState.NON_EXIST;
    private static InAppMessagingCallBack callBack;

    public static BannerPresenter getInstance(Activity currentActivity, InApp inApp , InAppMessagingCallBack callBack) {
        return new BannerPresenter(currentActivity, inApp , callBack);
    }

    private BannerPresenter(Activity currentActivity, InApp inApp, InAppMessagingCallBack callBack) {
        this.currentActivity = currentActivity;
        this.inApp = inApp;
        BannerPresenter.callBack = callBack;
    }
    private InAppState getStates(){
        return state;
    }

    private static void setStates(InAppState state) {
        BannerPresenter.state = state;
    }

    public void handleInApp() {
        popup = new BannerPopup();
        // type is always HEADER
        option = popup.prepareView(inApp.getType());

        popup.bindInApp(currentActivity,inApp.getBackgroundColor());
        popup.bindTitle(inApp.getTitle());

        if(inApp.getButtonPrimary().isAvailable())
            popup.bindPrimaryButton(inApp.getButtonPrimary());

        if (inApp.getButtonSecondary().isAvailable())
            popup.bindSecondaryButton(inApp.getButtonSecondary());

        popup.bindImage(currentActivity,inApp.getImage());

        popup.show(option,currentActivity,inApp.getCloseButton());

        setStates(InAppState.IS_RUNNING);
    }

    public void onActivityPaused() {
        if(getStates() != InAppState.CLOSED) { // this is the time that orientation has changed but in app not closed by user
            popup.dismiss();
            setStates(InAppState.IS_RUNNING);
        }
    }
    public void onActivityResumed(Activity currentActivity){
        this.currentActivity = currentActivity;
        if(getStates() == InAppState.IS_RUNNING)
            handleInApp();
    }

    public static void inAppClosed() { // this method called when user close in app
        Log.d("BannerItem", "inAppClosed: ");
        setStates(InAppState.CLOSED);
        callBack.inAppWasShown();
    }
}
