package com.najva.sdk.in_app_messaging.model;

public enum InAppState {
    NON_EXIST("nonExist"),
    IS_RUNNING("isRunning"),
    CLOSED("closed");

    private String stateToString;

    InAppState(String stateToString){
        this.stateToString = stateToString;
    }

    public String getStateToString() {
        return stateToString;
    }

    public static InAppState getState(String stateToString){
        for (InAppState states: InAppState.values()){
            if(states.getStateToString().equals(stateToString)){
                return states;
            }
        }
        return null;
    }
}
