package com.najva.sdk.in_app_messaging.model;

import android.graphics.Color;

import com.najva.sdk.in_app_messaging.view.InAppType;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;

public class InApp implements Serializable {
    private UUID id;
    private TextProperty title;
    private TextProperty description;
    private ButtonProperty buttonPrimary;
    private ButtonProperty buttonSecondary;
    private ImageProperty image;
    private CloseButton closeButton;
    private int backgroundColor;
    private InAppType type;
    private Date endDate;
    private boolean showInLowConnection;
    private long delay;


    public InApp() {
        this.backgroundColor = Color.WHITE;
        this.buttonPrimary = new ButtonProperty();
        this.buttonSecondary = new ButtonProperty();
        this.image = new ImageProperty();
        this.title = new TextProperty();
        this.description = new TextProperty();
        this.id = UUID.randomUUID();
        this.closeButton = new CloseButton();
        this.endDate = null;
        this.showInLowConnection = true;
        this.delay = 5000;
    }

    public UUID getId() {
        return id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public TextProperty getTitle() {
        return title;
    }

    public void setTitle(TextProperty title) {
        this.title = title;
    }

    public TextProperty getDescription() {
        return description;
    }

    public void setDescription(TextProperty description) {
        this.description = description;
    }

    public ButtonProperty getButtonPrimary() {
        return buttonPrimary;
    }

    public void setButtonPrimary(ButtonProperty buttonPrimary) {
        this.buttonPrimary = buttonPrimary;
    }

    public ButtonProperty getButtonSecondary() {
        return buttonSecondary;
    }

    public void setButtonSecondary(ButtonProperty buttonSecondary) {
        this.buttonSecondary = buttonSecondary;
    }

    public ImageProperty getImage() {
        return image;
    }

    public void setImage(ImageProperty image) {
        this.image = image;
    }

    public int getBackgroundColor() {
        return backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public InAppType getType() {
        return type;
    }

    public void setType(InAppType type) {
        this.type = type;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean isShowInLowConnection() {
        return showInLowConnection;
    }

    public void setShowInLowConnection(boolean showInLowConnection) {
        this.showInLowConnection = showInLowConnection;
    }

    public long getDelay() {
        return delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public CloseButton getCloseButton() {
        return closeButton;
    }

    public void setCloseButton(CloseButton closeButton) {
        this.closeButton = closeButton;
    }


    public static final class InAppBuilder {
        private UUID id;
        private TextProperty title;
        private TextProperty description;
        private ButtonProperty buttonPrimary;
        private ButtonProperty buttonSecondary;
        private ImageProperty image;
        private CloseButton closeButton;
        private int backgroundColor;
        private InAppType type;
        private Date endDate;
        private boolean showInLowConnection;
        private long delay;

        private InAppBuilder() {
        }

        public static InAppBuilder anInApp() {
            return new InAppBuilder();
        }

        public InAppBuilder withId(UUID id){
            this.id = id;
            return this;
        }
        public InAppBuilder withTitle(TextProperty title) {
            this.title = title;
            return this;
        }

        public InAppBuilder withDescription(TextProperty description) {
            this.description = description;
            return this;
        }

        public InAppBuilder withButtonPrimary(ButtonProperty buttonPrimary) {
            this.buttonPrimary = buttonPrimary;
            return this;
        }

        public InAppBuilder withButtonSecondary(ButtonProperty buttonSecondary) {
            this.buttonSecondary = buttonSecondary;
            return this;
        }

        public InAppBuilder withImage(ImageProperty image) {
            this.image = image;
            return this;
        }
        public InAppBuilder withCloseButton(CloseButton closeButton){
            this.closeButton = closeButton;
            return this;
        }

        public InAppBuilder withBackgroundColor(int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public InAppBuilder withType(InAppType type) {
            this.type = type;
            return this;
        }

        public InAppBuilder withEndDate(Date endDate) {
            this.endDate = endDate;
            return this;
        }

        public InAppBuilder withShowInLowConnection(boolean showInLowConnection) {
            this.showInLowConnection = showInLowConnection;
            return this;
        }

        public InAppBuilder withDelay(long delay) {
            this.delay = delay;
            return this;
        }

        public InApp build() {
            InApp inApp = new InApp();
            inApp.setButtonPrimary(this.buttonPrimary);
            inApp.setButtonSecondary(this.buttonSecondary);
            inApp.setDescription(this.description);
            inApp.setImage(this.image);
            inApp.setEndDate(this.endDate);
            inApp.setTitle(this.title);
            inApp.setType(this.type);
            inApp.setShowInLowConnection(this.showInLowConnection);
            inApp.setDelay(this.delay);
            inApp.setBackgroundColor(this.backgroundColor);
            inApp.setCloseButton(this.closeButton);
            return inApp;
        }
    }
}
