package com.najva.sdk.in_app_messaging.database;

import android.database.Cursor;
import android.database.CursorWrapper;

import com.najva.sdk.in_app_messaging.model.ButtonProperty;
import com.najva.sdk.in_app_messaging.model.CloseButton;
import com.najva.sdk.in_app_messaging.model.CloseButtonType;
import com.najva.sdk.in_app_messaging.model.ImageProperty;
import com.najva.sdk.in_app_messaging.model.InApp;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

import com.najva.sdk.in_app_messaging.database.InAppSchema.InAppTable.InAppColumn;
import com.najva.sdk.in_app_messaging.model.TextProperty;
import com.najva.sdk.in_app_messaging.view.InAppType;

class InAppCursorWrapper extends CursorWrapper {
    /**
     * Creates a cursor wrapper.
     *
     * @param cursor The underlying cursor to wrap.
     */
    InAppCursorWrapper(Cursor cursor) {
        super(cursor);
    }

    InApp getInApp() {
        UUID id = UUID.fromString(getString(getColumnIndex(InAppColumn.UUID)));
        int color = getInt(getColumnIndex(InAppColumn.COLOR));
        int type = getInt(getColumnIndex(InAppColumn.TYPE));
        Date endDate = new Date(getLong(getColumnIndex(InAppColumn.END_DATE)));
        boolean showInLowConnection = getInt(getColumnIndex(InAppColumn.SHOW_IN_LOW_CONNECTION)) == 1;
        long delay = getLong(getColumnIndex(InAppColumn.DELAY));

        TextProperty titleProperty = new TextProperty();
        titleProperty.setText(getString(getColumnIndex(InAppColumn.TITLE)));
        titleProperty.setColor(getInt(getColumnIndex(InAppColumn.TITLE_COLOR)));
        titleProperty.setVisibility(getInt(getColumnIndex(InAppColumn.TITLE_VISIBILITY)) == 1);
        titleProperty.setAvailable(getInt(getColumnIndex(InAppColumn.TITLE_AVAILABLE)) == 1);

        TextProperty descriptionProperty = new TextProperty();
        descriptionProperty.setText(getString(getColumnIndex(InAppColumn.DESCRIPTION)));
        descriptionProperty.setColor(getInt(getColumnIndex(InAppColumn.DESCRIPTION_COLOR)));
        descriptionProperty.setVisibility(getInt(getColumnIndex(InAppColumn.DESCRIPTION_VISIBILITY)) == 1);
        descriptionProperty.setAvailable(getInt(getColumnIndex(InAppColumn.DESCRIPTION_AVAILABLE)) == 1);

        ButtonProperty primaryBtnProperty = new ButtonProperty();
        primaryBtnProperty.setText(getString(getColumnIndex(InAppColumn.PRIMARY_BTN_TEXT)));
        primaryBtnProperty.setVisibility(getInt(getColumnIndex(InAppColumn.PRIMARY_BTN_VISIBILITY)) == 1);
        primaryBtnProperty.setAction(getString(getColumnIndex(InAppColumn.PRIMARY_BTN_ACTION)));
        primaryBtnProperty.setTextColor(getInt(getColumnIndex(InAppColumn.PRIMARY_BTN_TEXT_COLOR)));
        primaryBtnProperty.setBackgroundColor(getInt(getColumnIndex(InAppColumn.PRIMARY_BTN_BACKGROUND_COLOR)));
        primaryBtnProperty.setAvailable(getInt(getColumnIndex(InAppColumn.PRIMARY_BTN_AVAILABLE)) == 1);

        ButtonProperty secondBtnProperty = new ButtonProperty();
        secondBtnProperty.setText(getString(getColumnIndex(InAppColumn.SECONDARY_BTN_TEXT)));
        secondBtnProperty.setVisibility(getInt(getColumnIndex(InAppColumn.SECONDARY_BTN_VISIBILITY)) == 1);
        secondBtnProperty.setAction(getString(getColumnIndex(InAppColumn.SECONDARY_BTN_ACTION)));
        secondBtnProperty.setTextColor(getInt(getColumnIndex(InAppColumn.SECONDARY_BTN_TEXT_COLOR)));
        secondBtnProperty.setBackgroundColor(getInt(getColumnIndex(InAppColumn.SECONDARY_BTN_BACKGROUND_COLOR)));
        secondBtnProperty.setAvailable(getInt(getColumnIndex(InAppColumn.SECONDARY_BTN_AVAILABLE)) == 1);

        ImageProperty imageProperty = new ImageProperty();
        imageProperty.setImageUrl(getString(getColumnIndex(InAppColumn.IMAGE_URL)));
        imageProperty.setVisibility(getInt(getColumnIndex(InAppColumn.IMAGE_VISIBILITY)) == 1);
        imageProperty.setAction(getString(getColumnIndex(InAppColumn.IMAGE_ACTION)));

        CloseButton closeButton = new CloseButton();
        closeButton.setType(CloseButtonType.valueOf(getString(getColumnIndex(InAppColumn.CLOSE_BTN_TYPE))));
        closeButton.setColor(getInt(getColumnIndex(InAppColumn.CLOSE_BTN_COLOR)));


        return InApp.InAppBuilder.anInApp()
                .withId(id)
                .withBackgroundColor(color)
                .withType(InAppType.getInAppType(type))
                .withEndDate(endDate)
                .withShowInLowConnection(showInLowConnection)
                .withDelay(delay)
                .withTitle(titleProperty)
                .withDescription(descriptionProperty)
                .withButtonPrimary(primaryBtnProperty)
                .withButtonSecondary(secondBtnProperty)
                .withImage(imageProperty)
                .withCloseButton(closeButton)
                .build();
    }
}
