package com.najva.sdk.core.task;

import android.os.AsyncTask;
import android.util.Log;

public abstract class BaseAsyncTask<Params,Progress,Result> extends AsyncTask<Params,Progress,Result> {

    public interface AsyncTaskPostExecuteListener<T> {
        void onResult(T result);
    }

    private AsyncTaskPostExecuteListener<Result> listener;

    public BaseAsyncTask(AsyncTaskPostExecuteListener<Result> listener){
        this.listener = listener;
    }

    public BaseAsyncTask(){

    }


    @Override
    protected void onPostExecute(Result result) {
        Log.d("BaseAsync", "onPostExecute: " + result + listener);
        if (result!=null && listener!=null){
            listener.onResult(result);
        }
    }
}
