package com.najva.sdk.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ListUtils {


    public static <T> List<T> filter(List<T> list, Validator<T> validator) {
        List<T> newList = new ArrayList<>();
        for (T item : list) {
            if (validator.isValid(item)) {
                newList.add(item);
            }
        }
        return newList;
    }

    public static <T, S> List<T> map(List<S> list, Converter<S, T> converter) {
        List<T> newList = new ArrayList<>();
        for (S item : list) {
            newList.add(converter.convert(item));
        }
        return newList;
    }

    public static <T> List<T> group(List<T> list){
        Set<T> set = new HashSet<>(list);
        return new ArrayList<>(set);
    }

    public interface Validator<T> {
        boolean isValid(T item);
    }

    public interface Converter<T, S> {
        S convert(T item);
    }
}
