package com.najva.sdk.core;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

import java.util.Stack;

public class ActivityStack extends Stack<ActivityStack.ActivityInfo> implements Application.ActivityLifecycleCallbacks {
    public ActivityStack(){

    }

    public boolean isActivityRunning(){
        return peek().state == ActivityInfo.STATE_RUNNING;
    }

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        push(new ActivityInfo(getActivityShortName(activity)));
    }

    @Override
    public void onActivityStarted(Activity activity) {

    }

    @Override
    public void onActivityResumed(Activity activity) {
        try{
            peek().setState(ActivityInfo.STATE_RUNNING);
            SessionManager.getInstance().onStart();
        } catch (Exception ignored){}
    }

    @Override
    public void onActivityPaused(Activity activity) {
        try {
            peek().setState(ActivityInfo.STATE_PAUSED);
            SessionManager.getInstance().onStop();
        } catch (Exception ignored ){}
    }

    @Override
    public void onActivityStopped(Activity activity) {

    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(Activity activity) {
        try{
            pop();
        } catch (Exception ignored){}
    }

    private String getActivityShortName(Activity activity) {
        return activity.getComponentName().getShortClassName().replace(".", "");
    }

    class ActivityInfo {

        public static final int STATE_RUNNING = 0;
        public static final int STATE_PAUSED = 1;

        public ActivityInfo(String name){
            this.name = name;
            state = 0;
        }

        public void setState(int state) {
            this.state = state;
        }

        private String name;
        private int state;
    }
}
