package com.najva.sdk;

import androidx.annotation.DrawableRes;

public class NajvaConfiguration {
    private boolean inAppMessagingEnabled = true;
    private boolean scanForTagsEnabled = true;
    private boolean pushNotificationsEnabled = true;
    private boolean locationEnabled = false;
    private boolean firebaseEnabled = false;

    private UserSubscriptionListener userSubscriptionListener = null;
    private NajvaJsonDataListener najvaJsonDataListener = null;
    private NotificationReceiveListener receiveNotificationListener = null;
    private NotificationClickListener notificationClickListener = null;
    private @DrawableRes
    int notificationSmallIcon = R.drawable.ic_notification_icon;

    public void enableLocation() {
        locationEnabled = true;
    }

    public void disableLocation() {
        locationEnabled = false;
    }

    public void enablePushNotifications() {
        pushNotificationsEnabled = true;
    }

    public void disablePushNotifications() {
        pushNotificationsEnabled = false;
    }

    public boolean isFirebaseEnabled() {
        return firebaseEnabled;
    }

    public void setFirebaseEnabled(boolean firebaseEnabled) {
        this.firebaseEnabled = firebaseEnabled;
    }

        public void enableScanForTags() {
        scanForTagsEnabled = true;
    }

    public void disableScanForTags() {
        scanForTagsEnabled = false;
    }

    public void enableInappMessaging() {
        inAppMessagingEnabled = true;
    }

    public void disableInappMessaging() {
        inAppMessagingEnabled = false;
    }

    boolean isInAppMessagingEnabled() {
        return inAppMessagingEnabled;
    }

    boolean isLocationEnabled() {
        return locationEnabled;
    }

    boolean isPushNotificationsEnabled() {
        return pushNotificationsEnabled;
    }

    boolean isScanForTagsEnabled() {
        return scanForTagsEnabled;
    }

    public void setNajvaJsonDataListener(NajvaJsonDataListener najvaJsonDataListener) {
        this.najvaJsonDataListener = najvaJsonDataListener;
    }

    public void setUserSubscriptionListener(UserSubscriptionListener userSubscriptionListener) {
        this.userSubscriptionListener = userSubscriptionListener;
    }

    public NajvaJsonDataListener getNajvaJsonDataListener() {
        return najvaJsonDataListener;
    }

    public UserSubscriptionListener getUserSubscriptionListener() {
        return userSubscriptionListener;
    }

    boolean hasJsonDataListener() {
        return najvaJsonDataListener != null;
    }

    public boolean isPushNotificationEnabled() {
        return pushNotificationsEnabled;
    }

    public int getNotificationSmallIcon() {
        return notificationSmallIcon;
    }

    public void setNotificationSmallIcon(@DrawableRes int id) {
        this.notificationSmallIcon = id;
    }

    public NotificationReceiveListener getReceiveNotificationListener() {
        return receiveNotificationListener;
    }

    public void setReceiveNotificationListener(NotificationReceiveListener receiveNotificationListener) {
        this.receiveNotificationListener = receiveNotificationListener;
    }

    public NotificationClickListener getNotificationClickListener() {
        return notificationClickListener;
    }

    public void setNotificationClickListener(NotificationClickListener notificationClickListener) {
        this.notificationClickListener = notificationClickListener;
    }

    @Override
    public String toString() {
        return "NajvaConfiguration{" +
                "inAppMessagingEnabled=" + inAppMessagingEnabled +
                ", scanForTagsEnabled=" + scanForTagsEnabled +
                ", pushNotificationsEnabled=" + pushNotificationsEnabled +
                ", locationEnabled=" + locationEnabled +
                ", firebaseEnabled=" + firebaseEnabled +
                ", userSubscriptionListener=" + userSubscriptionListener +
                ", najvaJsonDataListener=" + najvaJsonDataListener +
                ", receiveNotificationListener=" + receiveNotificationListener +
                ", notificationClickListener=" + notificationClickListener +
                ", notificationSmallIcon=" + notificationSmallIcon +
                '}';
    }
}
