package com.najva.sdk.push_notification.handlers.compat;

import android.content.Context;

import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;

import com.najva.sdk.NajvaClient;
import com.najva.sdk.R;
import com.najva.sdk.core.utils.StaticFields;

import java.util.Map;

public class NormalNotificationHandlerCompat extends BaseNotificationHandlerCompat {
    public NormalNotificationHandlerCompat(Context context, Map<String, String> data, String messageId) {
        super(context, data, messageId);
    }

    @Override
    public void updateBuilderCompat(NotificationCompat.Builder builder) {
        builder.setAutoCancel(true);
        builder.setSmallIcon(NajvaClient.configuration.getNotificationSmallIcon());

        builder.setColorized(true);
        builder.setColor(ContextCompat.getColor(context, R.color.najva));
        builder.setLights(ContextCompat.getColor(context,R.color.najva),500,500);

        builder.setContentTitle(data.get(StaticFields.TITLE));
        builder.setContentText(data.get(StaticFields.BODY));
        sendNotificationCompat();
    }
}
