package com.najva.sdk.push_notification.handlers.compat;

import android.content.Context;

import androidx.core.app.NotificationCompat;

import com.najva.sdk.core.utils.StaticFields;

import java.util.Map;

public class BigTextNotificationHandlerCompat extends NormalNotificationHandlerCompat {
    public BigTextNotificationHandlerCompat(Context context, Map<String, String> data, String messageId) {
        super(context, data, messageId);
    }

    @Override
    public void updateBuilderCompat(NotificationCompat.Builder builder) {
        builder.setStyle(new NotificationCompat.BigTextStyle()
                .bigText(data.get(StaticFields.BODY))
                .setBigContentTitle(data.get(StaticFields.TITLE))
                .setSummaryText(data.get(StaticFields.SUMMARY))
        );
        super.updateBuilderCompat(builder);
    }
}
